include Makefile

PREFIX=/usr
BIN_PREFIX=$(PREFIX)/bin
SHARE_PREFIX=$(PREFIX)/share/$(TARGET)
DOC_PREFIX=$(PREFIX)/share/doc/$(TARGET)
MAN_PREFIX=$(PREFIX)/share/man/man1
ICONS_PREFIX=$(PREFIX)/share/icons
APPS_PREFIX=$(PREFIX)/share/applications
SHARES=translations/locale_pl.qm
DOCS=doc/README doc/ChangeLog doc/README.pl doc/ChangeLog.pl

install: all
	strip $(TARGET)
	$(INSTALL_PROGRAM) $(TARGET) $(BIN_PREFIX)/$(TARGET)
	$(MKDIR) $(SHARE_PREFIX)
	$(INSTALL_FILE) $(SHARES) $(SHARE_PREFIX)/
	$(MKDIR) $(DOC_PREFIX)
	$(INSTALL_FILE) $(DOCS) $(DOC_PREFIX)/
	$(MOVE) $(DOC_PREFIX)/ChangeLog $(DOC_PREFIX)/changelog
	$(COMPRESS) $(DOC_PREFIX)/changelog
	$(MOVE) $(DOC_PREFIX)/ChangeLog.pl $(DOC_PREFIX)/changelog.pl
	$(COMPRESS) $(DOC_PREFIX)/changelog.pl
	$(INSTALL_FILE) doc/manpage $(MAN_PREFIX)/$(TARGET).1
	$(COMPRESS) $(MAN_PREFIX)/$(TARGET).1
	$(INSTALL_FILE) res/computer-laptop.png $(ICONS_PREFIX)/
	$(INSTALL_FILE) doc/$(TARGET).desktop $(APPS_PREFIX)/

uninstall:
	$(DEL_FILE) $(BIN_PREFIX)/$(TARGET)
	$(DEL_FILE) -r $(SHARE_PREFIX)
	$(DEL_FILE) -r $(DOC_PREFIX)
	$(DEL_FILE) $(MAN_PREFIX)/$(TARGET).1.gz
	$(DEL_FILE) $(ICONS_PREFIX)/computer-laptop.png
	$(DEL_FILE) $(APPS_PREFIX)/$(TARGET).desktop
