/* Compal Laptop Control
 * Author: Krzemin <pkrzemin@o2.pl>
 * WWW: http://krzemin.iglu.cz
 * This software is distributed under the GNU General Public License.
 */

#include "compal.h"


bool cModuleAvailable()
{
	QFile modules(F_MODULES);
	if(!modules.open(QIODevice::ReadOnly | QIODevice::Text))
		return false;

	QTextStream in(&modules);
	QString line;

	do {
		line = in.readLine();
		if(line.indexOf("compal_laptop") == 0)
			return true;
	} while( !line.isNull() );

	modules.close();

	return false;
}

bool cCheckPermissions()
{
	return QFileInfo(F_BLUETOOTH).isWritable()
			&& QFileInfo(F_WLAN).isWritable()
			&& QFileInfo(F_LCD_LEVEL).isWritable();
}

bool cBtAvailable()
{
	QFile f(F_BLUETOOTH);
	return f.exists();
}

bool cWifiAvailable()
{
	QFile f(F_WLAN);
	return f.exists();
}

bool cBtStatus()
{
	QFile bt(F_BLUETOOTH);

	if(!bt.open(QIODevice::ReadOnly | QIODevice::Text))
		return false;

	int val = ((QString)(bt.readLine())).toInt();
	bt.close();
	return val;
}

bool cWifiStatus()
{
	QFile wifi(F_WLAN);

	if(!wifi.open(QIODevice::ReadOnly | QIODevice::Text))
		return false;

	int val = ((QString)(wifi.readLine())).toInt();
	wifi.close();
	return val;

}

int cLCDStatus()
{
	QFile lcd(F_LCD_LEVEL);

	if(!lcd.open(QIODevice::ReadOnly | QIODevice::Text))
		return false;

	int val = ((QString)(lcd.readLine())).toInt();

	lcd.close();
	return val;
}

void cSetBtStatus(bool status)
{
	QFile bt(F_BLUETOOTH);

	if(!bt.open(QIODevice::WriteOnly | QIODevice::Text))
		return;

	bt.write(status ? "1" : "0");
	bt.close();
}

void cSetWifiStatus(bool status)
{
	QFile wifi(F_WLAN);

	if(!wifi.open(QIODevice::WriteOnly | QIODevice::Text))
		return;

	wifi.write(status ? "1" : "0");
	wifi.close();
}

void cSetLCDStatus(int status)
{
	QFile lcd(F_LCD_LEVEL);

	if(!lcd.open(QIODevice::WriteOnly | QIODevice::Text))
		return;

	QTextStream out(&lcd);

	out << status;
	lcd.close();
}
