/* Compal Laptop Control
 * Author: Krzemin <pkrzemin@o2.pl>
 * WWW: http://krzemin.iglu.cz
 * This software is distributed under the GNU General Public License.
 */

#ifndef __COMPAL__H__
#define __COMPAL__H__

#include <QString>
#include <QFile>
#include <QFileInfo>
#include <QTextStream>

static const char	*F_MODULES = "/proc/modules",
					*F_BLUETOOTH = "/sys/devices/platform/compal-laptop/bluetooth",
					*F_WLAN = "/sys/devices/platform/compal-laptop/wlan",
					*F_LCD_LEVEL = "/sys/devices/platform/compal-laptop/lcd_level";

bool cModuleAvailable();
bool cCheckPermissions();

bool cBtAvailable();
bool cWifiAvailable();

bool cBtStatus();
bool cWifiStatus();
int cLCDStatus();

void cSetBtStatus(bool status);
void cSetWifiStatus(bool status);
void cSetLCDStatus(int status);

#endif
