/* Compal Laptop Control
 * Author: Krzemin <pkrzemin@o2.pl>
 * WWW: http://krzemin.iglu.cz
 * This software is distributed under the GNU General Public License.
 */

#ifndef __FRMCOMPAL__H__
#define __FRMCOMPAL__H__

#include "ui_frmcompal.h"
#include "compal.h"
#include "frmabout.h"
#include "qclcconfig.h"
#include <QWidget>
#include <QSystemTrayIcon>
#include <QMenu>
#include <QAction>
#include <QTimer>
#include <QApplication>
#include <QDesktopWidget>
#include <QPainter>
#include <QRegion>
#include <QPaintEvent>
#include <QMouseEvent>
#include <QPixmap>
#include <QBitmap>

class frmCompal: public QWidget
{
Q_OBJECT
	public:
		frmCompal(QWidget *parent = 0, Qt::WFlags f = 0);
		~frmCompal() {};

		void createTrayIcon();

	public slots:
		void setToolTip(const QString & tip);
		void updateUiStatus();
		void cbBluetoothToggled(bool checked);
		void cbWifiToggled(bool checked);
		void hsBrightnessChanged(int move);
		void iconActivated(QSystemTrayIcon::ActivationReason reason);
		void showHideWindow();
		void showAbout();
		void restoreClicked();
		void opacityClicked();

	private:
		Ui::frmCompal ui;
		QSystemTrayIcon *trayIcon;
		QMenu *trayIconMenu;

		QAction *showAction, *restoreAction, *opacityAction, *aboutAction, *quitAction;
		QTimer *updateTimer;

		frmAbout about;

		void wheelEvent(QWheelEvent *event);
		void keyPressEvent(QKeyEvent *event);
		void paintEvent(QPaintEvent *event);

	signals:
		void toolTipChange(const QString &);
};

const QPoint borderPoints[8] = {
	QPoint(2,0), QPoint(297,0), QPoint(299, 2), QPoint(299, 67),
	QPoint(297, 69), QPoint(2, 69), QPoint(0, 67), QPoint(0, 2)
};

#endif
