/* Compal Laptop Control
 * Author: Krzemin <pkrzemin@o2.pl>
 * WWW: http://krzemin.iglu.cz
 * This software is distributed under the GNU General Public License.
 */

#include <QApplication>
#include <QMessageBox>
#include <QSystemTrayIcon>
#include <QObject>
#include <QTranslator>
#include <QLocale>
#include "frmcompal.h"
#include "compal.h"
#include "config.h"

int main(int argc, char *argv[])
{
	QApplication app(argc, argv);

	QTranslator appTranslator;
	if(appTranslator.load("locale_" + QLocale::system().name().left(2), SHARE_DIR))
		app.installTranslator(&appTranslator);

	if(!cModuleAvailable())
	{
		QMessageBox::critical(0, QObject::tr("Error"),
			QObject::tr("Kernel module 'compal_laptop' hasn't been loaded.\n"
			"Install module first and try 'modprobe compal-laptop'!\n"
			"See %1/README for more details.").arg(DOC_DIR));
		return 1;
	}

	if(!cCheckPermissions())
	{
		QMessageBox::critical(0, QObject::tr("Error"),
			QObject::tr("You have not perrmisions to write following files:\n\n"
				"%1\n%2\n%3\n\nCheck your perrmission or run program in superuser mode.")
				.arg(F_BLUETOOTH).arg(F_WLAN).arg(F_LCD_LEVEL));
		return 1;
	}

	bool hasTray = QSystemTrayIcon::isSystemTrayAvailable();
	frmCompal main(0, (hasTray ? (Qt::Popup) : (Qt::WFlags)0));
	hasTray ? main.createTrayIcon() : main.show();

	return app.exec();
}
