/* QNapi
 * Autor: Krzemin <pkrzemin@o2.pl>
 * WWW: http://krzemin.iglu.cz
 * Ten program jest rozprowadzany na licencji GNU General Public License.
 */
#include "qclcconfig.h"

QClcConfig::QClcConfig()
{
	settings = new QSettings(QSettings::IniFormat, QSettings::UserScope, "compal-laptop-control");
}

QClcConfig::~QClcConfig()
{
	if(settings) delete settings;
}

void QClcConfig::reload()
{
	if(settings) delete settings;
	settings = new QSettings(QSettings::IniFormat, QSettings::UserScope, "compal-laptop-control");
}

void QClcConfig::save()
{
	settings->sync();
}

bool QClcConfig::restoreSettings()
{
	return settings->value("settings/restore_settings", true).toBool();
}

void QClcConfig::setRestoreSettings(bool restore)
{
	settings->setValue("settings/restore_settings", restore);
}

bool QClcConfig::opacity()
{
	return settings->value("settings/opacity", true).toBool();
}

void QClcConfig::setOpacity(bool opacity)
{
	settings->setValue("settings/opacity", opacity);
}

bool QClcConfig::bluetoothOn()
{
	return settings->value("settings/bluetooth", true).toBool();
}

void QClcConfig::setBluetoothOn(bool on)
{
	settings->setValue("settings/bluetooth", on);
}

bool QClcConfig::wlanOn()
{
	return settings->value("settings/wlan", true).toBool();
}

void QClcConfig::setWlanOn(bool on)
{
	settings->setValue("settings/wlan", on);
}

int QClcConfig::brightness()
{
	return settings->value("settings/brightness", true).toInt();
}

void QClcConfig::setBrightness(int value)
{
	settings->setValue("settings/brightness", value);
}

QClcConfig & GlobalConfig()
{
	static QClcConfig cfg;
	return cfg;
}
