/* QNapi
 * Autor: Krzemin <pkrzemin@o2.pl>
 * WWW: http://krzemin.iglu.cz
 * Ten program jest rozprowadzany na licencji GNU General Public License.
 */
#ifndef __QCLCCONFIG__H__
#define __QCLCCONFIG__H__

#include <QSettings>

class QClcConfig
{
	public:
		void reload();
		void save();

		bool restoreSettings();
		void setRestoreSettings(bool restore);
		bool opacity();
		void setOpacity(bool opacity);
		bool bluetoothOn();
		void setBluetoothOn(bool on);
		bool wlanOn();
		void setWlanOn(bool on);
		int brightness();
		void setBrightness(int value);

	private:
		QClcConfig();
		QClcConfig(const QClcConfig &);
		~QClcConfig();

		QSettings *settings;

	friend QClcConfig& GlobalConfig();
};

QClcConfig & GlobalConfig();

#endif
