
#include "bouchots.h"

#include <QtGui>
#include <QtNetwork>
#include <QDomDocument>
#include <QXmlSimpleReader>


// TODO: correct the problems with &eacute; etc. in updateTribune 
void convertPlopString(QString * inputString)
{
    
    
    inputString->replace("&lt;a href=&quot;", "<a href=\"");
    inputString->replace("&quot;&gt;&lt;b&gt;", "\"><b>");
    inputString->replace("&lt;/b&gt;&lt;/a&gt;", "</b></a>");
    inputString->replace("&lt;b&gt;","<b>");
    inputString->replace("&lt;/b&gt;","</b>");
    inputString->replace("&lt;i&gt;","<i>");
    inputString->replace("&lt;/i&gt;","</i>");
    inputString->replace("&lt;u&gt;","<u>");
    inputString->replace("&lt;/u&gt;","</u>");
    inputString->replace("&lt;tt&gt;","<tt>");
    inputString->replace("&lt;/tt&gt;","</tt>");
    inputString->replace("&lt;s&gt;","<s>");
    inputString->replace("&lt;/s&gt;","</s>");
    inputString->replace("&sup2;",QString::fromUtf8("²"));
  
    inputString->replace("&amp;","&");
    
    
}

QString convertNorloge(QString norlogeToConvert)
{
    QString Out = "%1/%2/%3#%4:%5:%6" ;
    // convert 20070222001353 to 22/02/2007#00:13:53
    if ( norlogeToConvert.size() != 14 )
        return norlogeToConvert ;
    QString annee = norlogeToConvert.left(4);
    QString mois = norlogeToConvert.mid(4,2) ;
    QString jour = norlogeToConvert.mid(6,2) ;
    QString heure = norlogeToConvert.mid(8,2) ;
    QString minute = norlogeToConvert.mid(10,2) ;
    QString seconde = norlogeToConvert.mid(12,2) ;
    
    
    return Out.arg(jour).arg(mois).arg(annee).arg(heure).arg(minute).arg(seconde) ;
    //return Out ;
}


QMap < QString, Bouchot *> readconfigfile()
{

	QString conffile;
	QMap < QString, Bouchot *> map_returned ;

#ifdef Q_OS_WIN32
	QString profilepath = getenv("USERPROFILE");
#else
	QString profilepath = getenv("HOME");
#endif
	profilepath.append("/.qoinqoin");
	conffile=profilepath;
	conffile.append("/options.auth");

	QDir confdir(profilepath);
	if (!confdir.exists())
	confdir.mkdir(profilepath);

  
	QFile qonffile(conffile);
	if (!qonffile.exists())
	{
		if (!qonffile.open(QIODevice::WriteOnly | QIODevice::Text))
		{
			//QMessageBox::critical(this,"Plop","/o\\ I could not create ~/.qoinqoin/configrc");
			qDebug("/o\\ I could not create ~/.qoinqoin/options.auth");
			return map_returned;
		}
      
		QTextStream out(&qonffile);
		
		out << "board_site: linuxfr , dlfp" << "\n" ;
		out << ".tribune.delay: 20" << "\n";
		out << ".backend_flavour: 1" << "\n";
		out << ".palmipede.useragent: QoinQoin/$v" << "\n";
		out << ".post.url: http://linuxfr.org/board/add.html" << "\n";
		out << ".backend.url: http://linuxfr.org/board/remote.xml" << "\n" ;
		out << ".post.template: message=%s&section=1" << "\n" ;
		out << ".cookie: unique_id=;md5=" << "\n" ;
		out << ".palmipede.userlogin: " << "\n";

		//QMessageBox::warning(this,"Plop","Please put your cookies in ~/.qoinqoin/configrc");
		qDebug("Please put your cookies in ~/.qoinqoin/options.auth");
		
		qonffile.close();
    }
	
  
	if (!qonffile.open(QIODevice::ReadOnly | QIODevice::Text))
	{
		//QMessageBox::critical(this,"Plop","/o\\ I could not open ~/.qoinqoin/configrc");
		qDebug("/o\\ I could not open ~/.qoinqoin/configrc");
		return map_returned;
    }
    
    QString confline ;
    QString tribune;

	QStringList temp_list ;
	QStringList listAliases ;
	QStringList L2 ;
	QTextStream in(&qonffile);
    
    int delay = 20 ;
    QString flavour = "";
    QString userAgent = "QoinQoin/$v";
    QString postUrl = "";
    QString backendUrl = "";
    QString postTemplate = "message=%s";
    QString cookie = "";
    QString login = "";
    QString encodage = "utf-8" ;
    QString bgColor = "dae6e6" ;
    
    
    

	
	confline = in.readLine();
	while (!in.atEnd()) {		
		if ( confline.startsWith("board_site: ") )
		{
			
			temp_list = confline.split(": ");
			if ( temp_list.size() != 2 )
			{
				//QMessageBox::critical(this,"Plop","/o\\ correct ~/.qoinqoin/configrc");
				qDebug("/o\\ correct ~/.qoinqoin/configrc");
				return map_returned;
			}
			tribune = temp_list.at(1);
			
			listAliases = tribune.split(" ");
			
			tribune = listAliases.at(0);
            listAliases.removeFirst();
            
            confline = in.readLine();
            if ( in.atEnd())
            {
                //QMessageBox::critical(this,"Plop","/o\\ correct ~/.qoinqoin/configrc");
                qDebug("/o\\ correct ~/.qoinqoin/configrc");
                return map_returned;
            }
            

            
			
			while ( !confline.startsWith("board_site: ") )
			{
				if ( confline.startsWith(".tribune.delay: ") )
				{
					L2 = confline.split(": ") ;
					if ( L2.size() == 2 )
					{
						delay = L2.at(1).toInt();
					}
				}
				else if ( confline.startsWith(".backend_flavour: ") )
				{
					L2 = confline.split(": ") ;
					if ( L2.size() == 2 )
					{
						flavour = L2.at(1).toInt();
					}
				}
				else if ( confline.startsWith(".palmipede.useragent: ") )
				{
					L2 = confline.split(": ") ;
					if ( L2.size() == 2 )
					{
						userAgent = L2.at(1);
					}
				}
				else if ( confline.startsWith(".post.url: ") )
				{
					L2 = confline.split(": ") ;
					if ( L2.size() == 2 )
					{
						postUrl = L2.at(1);
					}						
				}
				else if ( confline.startsWith(".backend.url: ") )
				{
					L2 = confline.split(": ") ;
					if ( L2.size() == 2 )
					{
						backendUrl = L2.at(1);
					}
				}
				else if ( confline.startsWith(".post.template: ") )
				{
					L2 = confline.split(": ") ;
					if ( L2.size() == 2 )
					{
						postTemplate = L2.at(1);
					}
				}
				else if ( confline.startsWith(".cookie: ") )
				{
					L2 = confline.split(": ") ;
					if ( L2.size() == 2 )
					{
						cookie = L2.at(1);
					}
				}
				else if ( confline.startsWith(".palmipede.userlogin: ") )
				{
					L2 = confline.split(": ") ;
					if ( L2.size() == 2 )
					{
						login = L2.at(1);
					}
				}
                else if ( confline.startsWith(".pinnipede.bg_color: ") )
                {
                    L2 = confline.split(": ") ;
                    if ( L2.size() == 2 )
                    {
                        bgColor = L2.at(1);
                    }
                }
                else if ( confline.startsWith(".encodage: ") )
                {
                    L2 = confline.split(": ") ;
                    if ( L2.size() == 2 )
                    {
                        encodage = L2.at(1);
                    }
                }                  
                
				confline = in.readLine();
				if ( in.atEnd() )
					break ;			
			}
            
            if ( ( tribune != "" ) and ( postUrl != "" ) and ( backendUrl != "" ) )
            {
                /*
                Bouchot *classTrib = new Bouchot(tribune, userAgent, postUrl, backendUrl,
                                            postTemplate, cookie, login, delay, 0);                
                
                classTrib->listAliases = listAliases;
                map_returned[tribune] = classTrib ;
                */
                userAgent.replace(QString("$v"), VERSIONNUMBER);
                map_returned[tribune] = new Bouchot(tribune, userAgent, postUrl, backendUrl,
                                            postTemplate, cookie, login, encodage, delay, 0);
                map_returned[tribune]->listAliases = listAliases;
                map_returned[tribune]->setBgColor(bgColor) ;
            }
            
            tribune = "" ;
            postUrl = "" ;
            backendUrl = "" ;
            postTemplate = "message=%s" ;
            encodage = "utf-8" ;
            userAgent = "QoinQoin/$v" ;
            bgColor = "dae6e6" ;
		}
	}
	qonffile.close();
	
	return map_returned ;

}


Bouchot::Bouchot(QString &tribune_name_in, QString &UA_in, QString &postUrl_in,
                QString &backendUrl_in, QString &postTemplate_in, QString &cookie_in,
                QString &login_in, QString &encodage_in, int delay_in, QWidget *parent)
     : QWidget(parent)
{
	mytext = "";
	lastmessage="";

	http = new QHttp(this);
  	httppost = new QHttp(this);
  	
  	backendFileName = "remote_" ;
	
	backendFileName.append(tribune_name_in) ;
	backendFileName.append(".xml");
	
	tribune = tribune_name_in;
	listAliases = tribune.split(" ");
	delay = delay_in ;
	flavour = 1 ;
	UA = UA_in;
	postUrl = postUrl_in;
	backendUrl = backendUrl_in;
	postTemplate = postTemplate_in;
	cookie = cookie_in;
	login = login_in ;
    encodage = encodage_in ;
	
	PiniText = new QTextBrowser ;
    PiniText->setOpenExternalLinks(true);
    
    PiniText->setHtml(mytext);
    //PiniText->loadResource(QTextDocument::ImageResource, QUrl("/") );
    QString sheet;
    //sheet.append("a[href=\"qt4-2-intro.html\"] { text-decoration: underline; font-style: italic; color: #00ff00; }");
    //sheet.append("a { text-decoration: none; }");
    sheet.append(tr("#norloge { color: #%1; }").arg(COLORNORLOGE));
    sheet.append(tr("#login { color: #%1; }").arg(COLORLOGIN));
    sheet.append(tr("#norlogemessage { color: #%1;}").arg(COLORNORLOGEMESSAGE));
    sheet.append(tr("#ua { color: #%1; font-style: italic;}").arg(UACOLOR));
    sheet.append(tr("#uaAnswer {background: #%1; color: #%2; font-style: italic;}").arg(BGLOGINANSWER).arg(UACOLOR));    
    sheet.append(tr("#mylogin {background: #%1; color: #%2; }").arg(BGMYLOGIN).arg(COLORLOGIN));
    sheet.append(tr("#loginAnswer {background: #%1; color: #%2; }").arg(BGLOGINANSWER).arg(COLORLOGIN));
    PiniText->document()->setDefaultStyleSheet(sheet);

    	
	PiniLayout = new QGridLayout ;
	PiniLayout->addWidget(PiniText, 0, 0);
	setLayout(PiniLayout);
	myscroll = new QScrollBar;
	myscroll = PiniText->verticalScrollBar();
    
    QTimer *timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(mywget()));
    timer->start(delay * 1000);
	
	connect(http, SIGNAL(requestFinished(int, bool)),this, SLOT(httpRequestFinished(int, bool)));
  	connect(httppost, SIGNAL(requestFinished(int, bool)),this, SLOT(httpRequestPostFinished(int, bool)));

    connect(http, SIGNAL(responseHeaderReceived(const QHttpResponseHeader &)),
      this, SLOT(readResponseHeader(const QHttpResponseHeader &)));
    connect(httppost, SIGNAL(responseHeaderReceived(const QHttpResponseHeader &)),
      this, SLOT(readResponseHeader(const QHttpResponseHeader &)));  	
  	
    connect(PiniText, SIGNAL(cursorPositionChanged()), this, SLOT(norlogeClicked()));
    
    connect(PiniText, SIGNAL(highlighted(const QString &)), this, SLOT(handleLinks(const QString & )));
    
}

Bouchot::~Bouchot()
{
	
}


QMap <QString, QString> Bouchot::getDatas()
{
	QMap <QString, QString> datas ;
	datas[QString("tribune")] = tribune ;
	datas[QString("UA")] = UA ;
	datas[QString("postUrl")] = postUrl ;
	datas[QString("backendUrl")] = backendUrl ;
	datas[QString("postTemplate")] = postTemplate ;
	datas[QString("cookie")] = cookie ;
	datas[QString("login")] = login ;
	
	return datas ;		
	
}

QString Bouchot::getLastMessage()
{
	return lastmessage;
}

QString Bouchot::getMyText()
{
	return mytext;	
}

void Bouchot::updateTribune0()
{
	qDebug(tribune.toLatin1().constData());

  QRegExp rxm1("<message>");
  QRegExp rxm2("</message>");
  QRegExp rxposttime1("<post time=");
  QRegExp rxposttime2("</post>");
  QRegExp rxinfo1("<info>");
  QRegExp rxinfo2("</info>");
  QRegExp rxlogin1("<login>");
  QRegExp rxlogin2("</login>");

  QRegExp rxgt(">");
  QString lastline;
  
  bool UpdateTextBox = false;


  QList<QString> listmessage;
  QList<QString> listnorloge;
  QList<QString> listlogin;
  QList<QString> listua;
 
  QString currenttext;
  int imess, inorl, ilogin, iua;
  imess=0;
  inorl=0;
  ilogin=0;
  iua=0;
  int i = 0;
  int k=0;


  QFile file(backendFileName);
  if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
    return;

  QTextStream in(&file);
  while (!in.atEnd()){
    QString line = in.readLine();

    if (rxposttime1.indexIn(line)!=-1)
      {
    line.replace(rxposttime1,"");
    line.remove(0,9);
    line.remove(6,line.size()-1);



    line.insert(2, QString(":"));
    line.insert(5,QString(":"));
    line.replace(rxgt,"");
    listnorloge << line ;
    inorl++;



      }
    if (rxlogin1.indexIn(line)!=-1)
      {
    line.replace(rxlogin1,"");
    line.replace(rxlogin2,"");
    listlogin << line ;
    ilogin++;

      }
    
    if (rxm1.indexIn(line)!= -1)
      {
    line.replace(rxm1,"");
    line.replace(rxm2,"");
    convertPlopString(&line);
    listmessage << line ;
    
    imess++;

    
      }



  }
  

  if ( listlogin.size() != 0 and listnorloge.size() != 0 and listmessage.size() != 0 )
  { 
    lastline=listlogin[0];
    lastline.append(listnorloge[0]);
    lastline.append(listmessage[0]);
  }
 
  if( lastmessage == "")
    {
      k=imess;
      
    }
  else
    {
        
      for(i=0;i<imess;i++)
         
    {
      if( lastline != lastmessage )
        {
          k=k+1;
          lastline=listlogin[k];
          lastline.append(listnorloge[k]);
          lastline.append(listmessage[k]);
          
            
        }
      
    }
    }

    QString mytext2 = "";
    

  for(i=k-1;i>=0;i--)
    {
        


      
      mytext2.append("<span style=\"color: rgb(255,121,121);\">");
      if ( listlogin[i] == "" )
        mytext2.append("Anonyme");
      else
        mytext2.append(listlogin[i]);
      mytext2.append("</span> ");
      mytext2.append("<span style=\"color: rgb(121,121,255);\">");
      mytext2.append(listnorloge[i]);
      mytext2.append("</span> ");
      mytext2.append(listmessage[i]);
      
      if ( listmessage[i].contains(login) and login != "")
            emit ontappelle(listnorloge[i], listmessage[i]);

      if ( i != 0 )
        mytext2.append("<br>");
      UpdateTextBox = true ;

    }
  
  if ( ( listlogin.size() != 0 ) and ( listnorloge.size() != 0 ) 
            and (listmessage.size() != 0 ) )
  { 
    lastmessage=listlogin[0];
    lastmessage.append(listnorloge[0]);
    lastmessage.append(listmessage[0]);
  }
  else
  {
    return;
  }
  
  
  
    if (UpdateTextBox)
    {
        bool updateScroll = false;
        QScrollBar *myscroll = PiniText->verticalScrollBar();
        int maxvalue = myscroll->maximum();
        
        if (myscroll->value() == maxvalue)
            updateScroll = true ;
        PiniText->append(mytext2);
        
        if ( updateScroll)
        {
            maxvalue = myscroll->maximum();
            myscroll->setValue(maxvalue);
        }
    }
  
	
}


void Bouchot::updateTribune()
{
    
#ifdef Q_OS_WIN32
    QString homepath = getenv("USERPROFILE");
#else
    QString homepath = getenv("HOME");
#endif
    QString totozPath ;
    totozPath = homepath ;
    totozPath.append(DIRTOTOZ);
    
    QFile file(backendFileName);
    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
        return;
    
    QString errorXmlString ;
    int errorXmlLine;
    int errorXmlCol;
    QDomDocument domDocument ;
    
    QXmlSimpleReader reader ;
     
     // The following has been stolen from kk but does not work
    
    reader.setFeature("http://xml.org/sax/features/namespaces", true);
    reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
    // Pour les tribunes comme dlfp
    reader.setFeature("http://trolltech.com/xml/features/report-start-end-entity", true);
    
    
    // On parse le backend
    
    QXmlInputSource input = QXmlInputSource(&file) ;
    
    if ( !domDocument.setContent(&input, &reader, &errorXmlString, &errorXmlLine,
                                 &errorXmlCol))
    {
        emit messageToMainWindow("Parsing error", tr("Parse error at line %1, column %2:\n%3")
                                  .arg(errorXmlString)
                                  .arg(errorXmlLine)
                                  .arg(errorXmlCol));
        file.close();
        return ;   
    }
    
    //reader.parse(input) ;
    
    
    
    // The following was my first test with xml
    /*
    if (!domDocument.setContent(&file, true, &errorXmlString, &errorXmlLine,
                                 &errorXmlCol))
    {
        emit messageToMainWindow("Parsing error", tr("Parse error at line %1, column %2:\n%3")
                                  .arg(errorXmlString)
                                  .arg(errorXmlLine)
                                  .arg(errorXmlCol));
        file.close();
        return ;
     }
    */
    QDomElement root = domDocument.documentElement();
    
    QDomNode child1 = domDocument.firstChild();
    if ( child1.isProcessingInstruction())
    {
        QDomProcessingInstruction xml = child1.toProcessingInstruction();
        QRegExp regexp("encoding = '((?:\\w|\\-)+)'");
        
        if ( regexp.indexIn(xml.data()) > -1 )
        {
            qDebug(tr("Encodage detected %1").arg(regexp.cap(1).toLower()).toAscii().data());
            this->encodage = regexp.cap(1).toLower() ;
        }
            
        
        
    }
    
    if (root.tagName() != "board")
    {
        emit messageToMainWindow("Parsing error", "The file is not a board file.");
        
        file.close();
        return ;
    }
    
    QDomElement postBouchot = root.firstChildElement("post");
    
    QString norloge_post = "" ;
    int id_post = -1 ;
    QString message_post = "" ;
    QString login_post = "" ;
    QString ua_post = "" ;
    QString ligne = "" ;
    bool updateTextBox = false ;
    QRegExp rxNorloge = QRegExp("(([01]?[0-9])|(2[0-3])):[0-5][0-9](:[0-5][0-9])?" );
    QRegExp rxTotoz = QRegExp("\\[:((?:\\w|\\d|-|_| |/)*)\\]");
    QMap < int, messageBouchot * > mapTempo ;
    QString totozName ;
    
    while (!postBouchot.isNull())
    {
        id_post = postBouchot.attribute("id").toInt();
        
        
        if ( mapPosts.contains(id_post) )
        {
            
            break ;
        }
        
        norloge_post = postBouchot.attribute("time");
        ua_post = postBouchot.firstChildElement("info").text();
        message_post = postBouchot.firstChildElement("message").text();
        login_post = postBouchot.firstChildElement("login").text();
        
        

        
        mapPosts[id_post] = new messageBouchot(norloge_post, ua_post, login_post, message_post);
        mapTempo[id_post] = new messageBouchot(norloge_post, ua_post, login_post, message_post);
        
        //ligne=tr("<span style=\"color: rgb(255,121,121);\"><acronym title=\"%4\">%1</acronym></span> <span style=\"color: rgb(121,121,255);\">%2</span> %3")
        //        .arg(login_post).arg(norloge_post).arg(message_post).arg(login_post);
        
        updateTextBox = true ;        
        
        
        
            
        norloge_post = "" ;
        id_post = -1 ;
        message_post = "" ;
        login_post = "" ;
        ua_post = "" ;
        postBouchot = postBouchot.nextSiblingElement("post");
        
    }
    
    QMap<int, messageBouchot * >::const_iterator it = mapTempo.constBegin();
    
    if ( mapTempo.count() == 0)
    {
        // c'est vide
    }
    else
    {
        
        while (it != mapTempo.constEnd())
        {
            
            


            
            
            
            norloge_post = convertNorloge(it.value()->getNorloge()).right(8) ;
            message_post = (it.value()->getMessage()) ;
            
                        

            
            if ( message_post.contains(login) and login != "")
                emit ontappelle(norloge_post, message_post);

            //needed to know if the message answer to one of mines
            bool answerToMine = false ;
            
            // the following is for misc. formatting in a message
            QStringList splittedMessage = message_post.split(" ");
            
            for (QStringList::const_iterator it42 = splittedMessage.constBegin(); it42 != splittedMessage.constEnd(); ++it42 )
            {
                
                if (rxNorloge.indexIn(*it42) != -1 )
                {
                    // check if the message answers to one of mine
                    
                    QMap<int, messageBouchot * >::const_iterator it43 = mapPosts.constBegin();
                    while ( it43 != mapPosts.constEnd() )
                    {                        
                        QString h = convertNorloge(it43.value()->getNorloge()).right(8) ;
                        if ( h.startsWith(*it42) )// The clock cited exists in the history
                        {
                            
                            //The corresponding message was one of mines
                            if (it43.value()->getLogin() == login )
                            {
                                
                                answerToMine = true ;
                                break ;
                                
                            }
                        }                        
                        ++it43 ;   
                    }
            
            
                    // this is for the clock formatting in a message            
                    message_post.replace(*it42, tr("<span id=\"norlogemessage\"><a href=\"#%1\">%1</a></span>").arg(*it42));                        
                }
                //this is for the totoz in a message        
                else if (rxTotoz.indexIn(*it42) != -1)
                {
                    totozName = it42->mid(2,it42->size()-3) ;
                    QString totozFile = tr("%1%2.gif").arg(totozPath).arg(totozName);
                        

                    //display the totoz only if I am able to do it
                    if (QImageReader(totozFile).canRead())
                        message_post.replace(*it42, tr("<img src=\"%1\" alt=\"%2\">")
                               .arg(totozFile).arg(totozName));
                }
                
            }
            
            
            //format the login
            //if it is empty or Anonyme< replace with the UA
            if ( ( it.value()->getLogin() == "" ) or (it.value()->getLogin() == "Anonyme") )
            {
                if ( answerToMine )
                    login_post = tr("<span id=\"uaAnswer\">%1</span>").arg(it.value()->getUa());
                else
                    login_post = tr("<span id=\"ua\">%1</span>").arg(it.value()->getUa());
            }
            else // it has a Login
            {
                //if it is me
                if ( it.value()->getLogin() == login )
                {
                    login_post = tr("<span id=\"mylogin\">%1</span>").arg(it.value()->getLogin()) ;
                }
                else // It is not me
                {
                    if ( answerToMine )
                        login_post = tr("<span id=\"loginAnswer\">%1</span>").arg(it.value()->getLogin()) ;
                    else    
                        login_post = tr("<span id=\"login\">%1</span>").arg(it.value()->getLogin()) ;
                    
                }
            }

            //Format the message in the QTextBrowser
            ligne=tr("<a name=\"%1\" id=\"%1\"></a><span id=\"norloge\">%1</span> %2 %3")
                .arg(norloge_post).arg(login_post).arg(message_post);
            //ligne=tr("<div id=\"norloge\">%1</div> <span style=\"color: rgb(255,121,121);\">%2</span> %3")
            //    .arg(norloge_post).arg(login_post).arg(message_post);
            PiniText->append(ligne);
            delete it.value() ;
            ++it ;
        }
    }
    file.close() ;
    
    if (updateTextBox)
    {
        bool updateScroll = false;
        QScrollBar *myscroll = PiniText->verticalScrollBar();
        int maxvalue = myscroll->maximum();
        
        if (myscroll->value() == maxvalue)
            updateScroll = true ;
        
        if ( updateScroll)
        {
            maxvalue = myscroll->maximum();
            myscroll->setValue(maxvalue);
        }
    }
    
    
}
 



void Bouchot::mywget()
{
	QUrl url(backendUrl);
	QFileInfo fileInfo(url.path());
	//QString fileName = fileInfo.fileName();
	
	
	
	
	file = new QFile(backendFileName);
	if (!file->open(QIODevice::WriteOnly)) {
    	QMessageBox::information(this, tr("HTTP"),
			     tr("Unable to save the file %1: %2.")
			     .arg(backendFileName).arg(file->errorString()));
    	delete file;
    	file = 0;
    	return;
	}
	
	
	qDebug((backendUrl.toLatin1() ).data());
	
	http->setHost(url.host(), url.port() != -1 ? url.port() : 80);
	if (!url.userName().isEmpty())
	    http->setUser(url.userName(), url.password());

	httpRequestAborted = false;
	httpGetId = http->get(url.path(), file);

	//UpdateButton->setEnabled(false);
    emit updateTribuneStarted();
	
}

void Bouchot::httpRequestFinished(int requestId, bool error)
{
	if (httpRequestAborted)
	{
    	if (file)
    	{
			file->close();
      		file->remove();
      		delete file;
      		file = 0;
    	}
	
		return;
	}
	
	if (requestId != httpGetId)
    	return;
	
	file->close();

	if (error)
	{
		file->remove();
    	QMessageBox::information(this, tr("HTTP"),
			     tr("Download failed: %1.")
			     .arg(http->errorString()));
  	}
  	else
  	{
    	QString fileName = QFileInfo(QUrl(backendUrl).path()).fileName();
    }

	delete file;
	file = 0;
	qDebug("updating tribune");
	
	updateTribune();
	
    emit updateTribuneFinished();
	//UpdateButton->setEnabled(true);
}

void Bouchot::httpRequestPostFinished(int requestId, bool error)
{
	if (httpRequestPostAborted)
		return;

	if (requestId != httpPostId)
    	return;
	
	if (error) {
    QMessageBox::information(this, tr("HTTP"),
			     tr("Sending failed: %1.")
			     .arg(httppost->errorString()));
	} else {
	
	}
    emit postingFinished();
    mywget();
}


void Bouchot::postMessage(QString & strIn)
{
    
    strIn.replace("&", "%26") ;
    strIn.replace("+", "%2b") ;
    QUrl::toPercentEncoding(strIn);
    postTemplate.replace("%s", "%1");
    strIn = QString(postTemplate).arg(strIn);
    
    QUrl url(postUrl);
    httppost->setHost(url.host(), url.port() != -1 ? url.port() : 80);
    
    httpRequestPostAborted = false;
    
    QHttpRequestHeader header("POST", url.path());
    header.setValue("Host", url.host());

    header.setContentType("application/x-www-form-urlencoded");
    header.setValue("User-Agent", UA);
    
    header.setValue( "Cookie", cookie);
 
    if ( encodage == "iso-8859-1" or encodage == "iso-8859-15")
    {
        qDebug("Latin1");
        
        httpPostId = httppost->request(header, strIn.toLatin1());
    }
    else
    {
        
        qDebug("utf8");
        httpPostId = httppost->request(header, strIn.toUtf8());
    }
    
    //OKButton->setEnabled(false);
    emit postingStarted();
    
}


void Bouchot::readResponseHeader(const QHttpResponseHeader &responseHeader)
{
    
    if ((responseHeader.statusCode() != 200) and (responseHeader.statusCode() != 302))
    {
        
        emit messageToMainWindow(QString("Connection Error"),
        tr("%1 (%2)").arg(responseHeader.reasonPhrase()).arg(responseHeader.statusCode()));
        //trayIcon->showMessage("Connection Error",
         //tr("%1 (%2)").arg(responseHeader.reasonPhrase()).arg(responseHeader.statusCode()));
        /*httpRequestAborted = true;
        http->abort();*/
        return;
    }
}

void Bouchot::norlogeClicked()
{
    QString c = PiniText->textColor().name().remove("#");
    if (c == COLORNORLOGE)
    {
        QTextCursor norlogeCursor = PiniText->textCursor();
        norlogeCursor.select(QTextCursor::LineUnderCursor);
        QString ligne = norlogeCursor.selectedText();
        QStringList lineList = ligne.split(" ", QString::SkipEmptyParts);
        if (lineList.size() > 0)
        {
            QString norlogeSelected = lineList.at(0);
            qDebug(norlogeSelected.toLatin1().data());
            
            emit norlogeToInsert(norlogeSelected);
            /*
            LineCommand->insert(norlogeSelected.append(" "));
            LineCommand->setFocus();
            */
        }   
    }
    else if ( c == COLORNORLOGEMESSAGE )
    {
        QTextCursor norlogeCursor = PiniText->textCursor();
        norlogeCursor.select(QTextCursor::WordUnderCursor);
        qDebug(norlogeCursor.selectedText().toAscii().data());
        
    }
    
}



void Bouchot::setBgColor(QString & bgColor )
{
    
    PiniText->setStyleSheet(tr("background-color: #%1;").arg(bgColor));
    
    
    
    
}


void Bouchot::handleLinks(const QString & hyperLink)
{

    //PiniText->loadResource(QTextDocument::HtmlResource, QUrl(hyperLink));
    QString linkToDisplay = QString(hyperLink);
    QString titleToDisplay = "Link" ;
    QString clockNotFound = "This clock does not exists (like the cabale<)" ;
    
    if ( linkToDisplay[0] == '#' )
    {
        linkToDisplay =  linkToDisplay.mid(1) ;
        bool foundCorrespondingNolorge = false;
        
        QMap<int, messageBouchot * >::const_iterator it = mapPosts.constBegin();
        while ( it != mapPosts.constEnd() )
        {
            
            QString h = convertNorloge(it.value()->getNorloge()).right(8) ;
            
            if ( h.startsWith(linkToDisplay) )
            {
                
                
                QString m = it.value()->getLogin();
                m.append(" ");
                m.append(it.value()->getMessage());

                emit messageToStatus(m);
                foundCorrespondingNolorge = true ;
            }

            
            ++it ;
        }
        if ( !foundCorrespondingNolorge )
        
            emit messageToStatus(clockNotFound);
        //emit ontappelle(titleToDisplay, linkToDisplay);
        
    }
    else
        emit messageToStatus(linkToDisplay);
}


messageBouchot::messageBouchot(QString postNorloge, 
                            QString postUA, QString postLogin, QString postMessage)
{
    norloge = postNorloge ;
    ua = postUA ;
    login = postLogin ;
    message = postMessage ;
}

messageBouchot::~messageBouchot()
{

}

QString messageBouchot::getNorloge()
{
    return norloge ;
}

QString messageBouchot::getUa()
{
    return ua ;
}

QString messageBouchot::getLogin()
{
    return login ;    
}

QString messageBouchot::getMessage()
{
    return message ;
}
