#include <QtGui>
#include <QtNetwork>

#include "central.h"
#include "commons.h"
#include "bouchots.h"
/*
 * 
 * TODO: - check mytext/mytext2
 *       -
 */

CentralWidget::CentralWidget(QWidget *parent)
  : QWidget(parent)
{
    
    

#ifdef Q_OS_WIN32
    QString homepath = getenv("USERPROFILE");
#else
    QString homepath = getenv("HOME");
#endif
    

    QDir confdir(tr("%1/.qoinqoin").arg(homepath));
    if (!confdir.exists())
        confdir.mkdir(tr("%1/.qoinqoin").arg(homepath));
    
    QDir totozdir(tr("%1/.qoinqoin/totoz").arg(homepath));
    if (!totozdir.exists())
        totozdir.mkdir(tr("%1/.qoinqoin/totoz").arg(homepath));
    
    
    
    
	lesTribunes = readconfigfile() ;

	createBoxPini();

    
    //createActions();
    //createTrayIcon();
    //trayIcon->show();
	
	
	QGridLayout *grid = new QGridLayout;
  	grid->addWidget(PiniBox,0,0);

            
    //myStatus = new QStatusBar() ;
    //myStatus->setFixedHeight(9);
    //grid->addWidget(myStatus,2, 0);
    
    
  	setLayout(grid);
  	
    
}


CentralWidget::~CentralWidget()
{
	


    for ( QMap < QString, Bouchot *>::const_iterator itPlop = lesTribunes.constBegin(); 
                    itPlop != lesTribunes.constEnd(); ++itPlop)
    {
        delete itPlop.value() ;
    }
    
    delete tabWidget ;
    
    
    delete PiniLayout ;
    delete PiniBox ;
    
}

void CentralWidget::createBoxPini()
{
	
	
	
	PiniBox = new QGroupBox("Pinipede teletype");
	
	PiniLayout = new QGridLayout;	
	tabWidget = new QTabWidget;
	
	QMap<QString, Bouchot * >::const_iterator i = lesTribunes.constBegin();
	if ( lesTribunes.count() == 0)
	{
		qDebug("You should define some tribunes");
	}
	
	 while (i != lesTribunes.constEnd())
	 {
	 	QString trib = i.key() ;
	 	(i.value())->mywget() ;
	 	tabWidget->addTab(i.value(), trib);
        //connect(http, SIGNAL(requestFinished(int, bool)),this, SLOT(httpRequestFinished(int, bool)));
        connect(i.value(), SIGNAL(ontappelle(QString&, QString&)), this, SLOT(bigornophone(QString&, QString&)));
        
        connect(i.value(), SIGNAL(postingStarted()), this, SLOT(startingPost()));
        connect(i.value(), SIGNAL(postingFinished()), this, SLOT(finishingPost()));
        
        connect(i.value(), SIGNAL(norlogeToInsert(QString)), this, SLOT(insertNorloge(QString)));        
        
        connect(i.value(), SIGNAL(messageToStatus(QString &)), this, SLOT(displayStatus(QString &)));
        
	 	
     	++i;
     }
	
	
	PiniLayout->addWidget(tabWidget,0,0);
	
	PiniBox->setLayout(PiniLayout);
	
}




void CentralWidget::bigornophone(QString & norloge, QString & mess)
{
    //trayIcon->showMessage(norloge, mess);
    emit messageToTrayer(norloge, mess);
    //trayer->displaymessage(mess);
    //QMessageBox::information(this, tr("plop"),mess);
    //qDebug(mess.toUtf8().data());
    
}



void CentralWidget::insertNorloge(QString norloge)
{
    emit norlogeToInsert(norloge);
}


void CentralWidget::displayStatus(QString & statusToDisplay)
{
    //myStatus->showMessage(statusToDisplay, 5000);
    emit messageToMainStatus(statusToDisplay);
}

void CentralWidget::startingPost()
{
    emit postingStarted();   
}

void CentralWidget::finishingPost()
{
    emit postingFinished();   
}

