#ifndef CENTRAL_H_
#define CENTRAL_H_
#include <QWidget>


#include "commons.h"
#include "bouchots.h"

#ifdef Q_OS_WIN32
#define ARTISHOW ":/xpms/artishow16x16.xpm"
#define Q2ICON ":/xpms/q2_16x16.xpm"
#else
#define ARTISHOW ":/xpms/artishow22x22.xpm"
#define Q2ICON ":/xpms/q2_22x22.xpm"
#endif





	class QGroupBox;
    class QHBoxLayout;
    class QGridLayout;
    class QTabWidget;

    
class CentralWidget : public QWidget
{
	Q_OBJECT
	
    public:
		CentralWidget(QWidget *parent=0);
		~CentralWidget();
		
		void createBoxPini();
        
        
        QMap < QString, Bouchot *> lesTribunes ;
        QTabWidget *tabWidget;
    
    public slots:
        void bigornophone(QString & norloge, QString & mess);
        void displayStatus(QString & statusToDisplay) ;
        void insertNorloge(QString);
        void startingPost();
        void finishingPost();
    
    signals:
        void messageToMainStatus(QString & statusToDisplay);
        void messageToTrayer(QString &, QString &);
        void norlogeToInsert(QString);
        void postingStarted();
        void postingFinished();
        
	
	private:
			
		QGroupBox * PiniBox;
		
		QGridLayout * PiniLayout ;

};
#endif /*CENTRAL_H_*/
