#include <QtGui>
#include "mainwindow.h"


MainWindow::MainWindow()
{
    setWindowTitle(QString("QoinQoin %1").arg(VERSIONNUMBER));
    
    
    central = new CentralWidget() ;
    setCentralWidget(central);
    statusBar()->showMessage(tr("Ready"));
    
    
    Qartishow = QIcon(ARTISHOW) ;
    Q2icon = QIcon(Q2ICON) ;
        
    createActions();
    createTrayIcon();
    trayIcon->show();
    
    createDock();
    createToolBar();
    
    connect(central, SIGNAL(messageToMainStatus(QString &)), this, SLOT(displayStatus(QString &)));
    connect(central, SIGNAL(messageToTrayer(QString &, QString &)), this, SLOT(displayTrayMessage(QString &, QString &)));
    
    connect(central, SIGNAL(postingStarted()), this, SLOT(OKDisabled()));
    connect(central, SIGNAL(postingFinished()), this, SLOT(OKEnabled()));
}

MainWindow::~MainWindow()
{
    //QByteArray etat = this->saveState();
    //qDebug(etat.data());
    delete central;
    delete minimizeAction;
    delete maximizeAction;
    delete restoreAction;
    delete switchIconAction ;
    delete quitAction;
    delete trayIconMenu;
    
    delete trayIcon ; 
    
    
    
    delete lineMessage ;
    delete lineDock;
    
    delete boldAct;
    delete italAct;
    delete underAct;
    delete strikeAct;
    delete momentAct;
    delete okAct ;
    delete buttonToolBar ;
    
}

void MainWindow::displayStatus(QString & statusToDisplay)
{
    statusBar()->showMessage(statusToDisplay, 5000);
}

void MainWindow::createActions()
{
    //trayer actions
    minimizeAction = new QAction(tr("Mi&nimize"), this);
    connect(minimizeAction, SIGNAL(triggered()), this, SLOT(hide()));
    maximizeAction = new QAction(tr("Ma&ximize"), this);

    connect(maximizeAction, SIGNAL(triggered()), this, SLOT(showMaximized()));

    restoreAction = new QAction(tr("&Restore"), this);
    connect(restoreAction, SIGNAL(triggered()), this, SLOT(show()));
    
    switchIconAction = new QAction(tr("Switch &icon"), this);
    connect(switchIconAction, SIGNAL(triggered()), this, SLOT(switchTrayIcon()));

    quitAction = new QAction(tr("&Quit"), this);
    connect(quitAction, SIGNAL(triggered()), qApp, SLOT(quit()));
    
    //button actions
    //TODO: tooltips, icons and shortcuts if icons
    boldAct = new QAction(QIcon(":/xpms/text_bold.png"), tr("&bold"), this) ;
    italAct = new QAction(QIcon(":/xpms/text_italic.png"), tr("&italic"), this);
    strikeAct = new QAction(QIcon(":/xpms/text_strike.png"), tr("&strike"), this);
    underAct = new QAction(QIcon(":/xpms/text_under.png"), tr("&underline"), this);
    momentAct = new QAction(QIcon(":/xpms/moment.png"), tr("=>&M<="), this);
    okAct = new QAction(QIcon(":/xpms/ok.png"), tr("O&K"), this);
    
    connect(boldAct, SIGNAL(triggered()), this, SLOT(insertBold()));
    connect(italAct, SIGNAL(triggered()), this, SLOT(insertItalic()));
    connect(strikeAct, SIGNAL(triggered()), this, SLOT(insertStrike()));
    connect(underAct, SIGNAL(triggered()), this, SLOT(insertUnderline()));
    connect(momentAct, SIGNAL(triggered()), this, SLOT(insertMoment()));
    
    connect(okAct, SIGNAL(triggered()), this, SLOT(postMessage()));
    
    
    
}





void MainWindow::createTrayIcon()
{
    trayIconMenu = new QMenu(this);

    trayIconMenu->addAction(minimizeAction);
    trayIconMenu->addAction(maximizeAction);
    trayIconMenu->addAction(restoreAction);
    trayIconMenu->addAction(switchIconAction);
    trayIconMenu->addSeparator();
    trayIconMenu->addAction(quitAction);

    trayIcon = new QSystemTrayIcon(this);
    trayIcon->setContextMenu(trayIconMenu);
    

    trayIcon->setIcon(Qartishow);
    
    connect(trayIcon, SIGNAL(activated(QSystemTrayIcon::ActivationReason)),
             this, SLOT(iconActivated(QSystemTrayIcon::ActivationReason)));

}

void MainWindow::displayTrayMessage(QString & title, QString & message)
{
    trayIcon->showMessage(title, message);    
}




void MainWindow::switchTrayIcon()
{
    

    int n = trayIcon->icon().serialNumber();
    trayIcon->showMessage("plop", "switching icon");
    if ( n == Qartishow.serialNumber() )
    {
        trayIcon->setIcon(Q2icon) ;             
    }
    else
    {
        trayIcon->setIcon(Qartishow) ;  
    }   
    
}


void MainWindow::switchWindowHiddenMode()
{
    if (this->isHidden()) 
        this->show();
    else
        this->hide();     
    
}





void MainWindow::iconActivated(QSystemTrayIcon::ActivationReason reason)
{
    switch ( reason )
    {
        case QSystemTrayIcon::Trigger:
            break;
        case QSystemTrayIcon::DoubleClick:
            switchWindowHiddenMode() ;
            break ;
        case QSystemTrayIcon::MiddleClick:
            switchTrayIcon() ;
            break ;
        default:
            ;       
    }   
}

void MainWindow::createDock()
{
    lineDock = new QDockWidget(tr("Palmipede Editor"), this);
    lineMessage = new QLineEdit(tr("coin ! coin !"));

    lineDock->setWidget(lineMessage);
    addDockWidget(Qt::BottomDockWidgetArea, lineDock);
    
    connect(lineMessage, SIGNAL(returnPressed()), this, SLOT(postMessage()));
    connect(central, SIGNAL(norlogeToInsert(QString)), this, SLOT(insertNorloge(QString)));
}

void MainWindow::createToolBar()
{
    
    buttonToolBar =  addToolBar(tr("Actions"));
    
    buttonToolBar->addAction(boldAct);
    buttonToolBar->addAction(italAct);
    buttonToolBar->addAction(underAct);
    buttonToolBar->addAction(strikeAct);
    buttonToolBar->addAction(momentAct);
    buttonToolBar->addAction(okAct);
    buttonToolBar->setMovable(true);
    //buttonToolBar->addAction(blamAct);
    
    
}


void MainWindow::insertNorloge(QString norloge)
{
    lineMessage->insert(norloge.append(" "));
    lineMessage->setFocus();    
}





void MainWindow::insertBold()
{
  
  this->insertAutour(tr("<b>"), tr("</b>"));
  this->lineMessage->setFocus();

}

void MainWindow::insertItalic()
{
  
  this->insertAutour(tr("<i>"), tr("</i>"));
  this->lineMessage->setFocus();

}

void MainWindow::insertUnderline()
{
  
  this->insertAutour(tr("<u>"), tr("</u>"));
  this->lineMessage->setFocus();

}

void MainWindow::insertStrike()
{
  
  this->insertAutour(tr("<s>"), tr("</s>"));
  this->lineMessage->setFocus();

}

void MainWindow::insertMoment()
{
  this->insertAutour(tr("====> <b>Moment "), tr("</b> <===="));
  this->lineMessage->setFocus();

}

void MainWindow::insertBlam()
{
  
  this->lineMessage->insert("_o/* <b>BLAM</b>!");
  this->lineMessage->setFocus();

}

void MainWindow::insertPaf()
{  
  this->lineMessage->insert("_o/* <b>PAF</b>!");
  this->lineMessage->setFocus();
}



void MainWindow::insertTotoz()
{
    
  this->insertAutour(tr("[:"), tr("]"));
  this->lineMessage->setFocus();
}

void MainWindow::insertAutour(QString leftTruc,QString rightTruc)
{
    int p0 = lineMessage->cursorPosition();
    QString stringToInsert = leftTruc ;
    stringToInsert.append(rightTruc);
    lineMessage->insert(stringToInsert);
    lineMessage->setCursorPosition(p0 + leftTruc.size());
    
}




/////////// Functions to post ////////////////

void MainWindow::postMessage()
{
    QString strIn = lineMessage->displayText() ;
    int currentTab = central->tabWidget->currentIndex();
    int k = 0 ;

    
    QMap<QString, Bouchot * >::const_iterator i = central->lesTribunes.constBegin();
    if ( central->lesTribunes.count() == 0)
    {
        return ;
    }
    
    while (i != central->lesTribunes.constEnd())
     {
        if (k == currentTab)
        {

            (i.value())->postMessage(strIn) ;
            break ;
            
        }
        ++k ;       
        ++i;
     }

}

void MainWindow::OKEnabled()
{
    okAct->setEnabled(true);   
    
}



void MainWindow::OKDisabled()
{
    okAct->setEnabled(false);
    
}

/////////// End of functions to post ////////////////


////////// Functions to update a tribune ////////////

void MainWindow::updateActiveTribune()
{

    int currentTab = central->tabWidget->currentIndex();
    int k = 0 ;
    
    QMap<QString, Bouchot * >::const_iterator i = (central->lesTribunes).constBegin();
    if ( central->lesTribunes.count() == 0)
    {
        return ;
    }
    
    while (i != central->lesTribunes.constEnd())
     {
        if (k == currentTab)
        {

            (i.value())->mywget() ;
            break ;
            
        }
        ++k ;       
        ++i;
     }

}


////////// End of functions to update a tribune ////////////

