#ifndef MAINWINDOW_H_
#define MAINWINDOW_H_

#include "central.h"



    class MainWindow;
    class QLineEdit;
    class QDockWidget ;
    class QToolBar ;


class MainWindow : public QMainWindow
{
    Q_OBJECT

    public:
        MainWindow();
        ~MainWindow();
        
    
    public slots:
        void displayStatus(QString &);
        void displayTrayMessage(QString &, QString &);
        void switchTrayIcon();        
        void iconActivated(QSystemTrayIcon::ActivationReason reason);        
        void switchWindowHiddenMode();
        
        
        
        
        void insertNorloge(QString norloge);        
            
        void insertMoment();
        void insertPaf();
        void insertBlam();
        void insertBold();
        void insertItalic();
        void insertUnderline();
        void insertStrike();
        void insertTotoz();
        void insertAutour(QString leftTruc,QString rightTruc);

        void postMessage();
        void OKEnabled();
        void OKDisabled();        
            
    private:
        void createTrayIcon();
        void createActions();
        void createDock();
        void createToolBar();
        

        
        void updateActiveTribune();
        
        
        CentralWidget * central ;
        QAction *minimizeAction;
        QAction *maximizeAction;
        QAction *restoreAction;
        QAction *switchIconAction ;
        QAction *quitAction;
    
        QSystemTrayIcon *trayIcon ; 
        QMenu *trayIconMenu;
    
        QIcon Qartishow ;
        QIcon Q2icon ;   
        
        QDockWidget * lineDock;
        QLineEdit * lineMessage ;        
        QToolBar * buttonToolBar ;
        QAction * boldAct;
        QAction * italAct;
        QAction * underAct;
        QAction * strikeAct;
        QAction * momentAct;
        QAction * okAct ;
        //QAction * blamAct;
        
};


#endif
