#include "totoz.h"
#include <QtGui>
#include <QtNetwork>
#include <QString>
bool istotozthere(QString & totozname)
{
    
#ifdef Q_OS_WIN32
    QString homepath = getenv("USERPROFILE");
#else
    QString homepath = getenv("HOME");
#endif
    QString totozFileName = homepath ;
    totozFileName.append("/.qoinqoin/totoz/");
    totozFileName.append(totozname);
    QFile totozfile(totozFileName);
    if (!totozfile.exists())
        return true ;
    else
        return false;    
}


Totoz::Totoz(QString & totozName)
{
    http = new QHttp(this);
    serverTotoz = "http://forum.hardware.fr/images/perso/" ;
    fullTotozName = tr("%1%2").arg(serverTotoz).arg(totozName);
    
    if ( istotozthere(totozName) )
    {
        emit sendUpdate();
        return ;
    }
    
#ifdef Q_OS_WIN32
    QString homepath = getenv("USERPROFILE");
#else
    QString homepath = getenv("HOME");
#endif
    localTotozName = tr("%1/.qoinqoin/totoz/%2").arg(homepath).arg(totozName) ;
    QFile file(localTotozName);    
    
    http = new QHttp(this);
    
    connect(http, SIGNAL(requestFinished(int, bool)),this, SLOT(httpRequestFinished(int, bool)));
    connect(http, SIGNAL(responseHeaderReceived(const QHttpResponseHeader &)),
      this, SLOT(readResponseHeader(const QHttpResponseHeader &)));
    
}

Totoz::~Totoz()
{
    delete http ;
}

void Totoz::httpRequestFinished(int requestId, bool error)
{
    if (httpRequestAborted)
    {
        if (file)
        {
            file->close();
            file->remove();
            delete file;
            file = 0;
        }
    
        return;
    }
    
    if (requestId != httpGetId)
        return;
    
    file->close();

    if (error)
    {
        file->remove();
        //QDebug(tr("Download failed: %1.").arg(http->errorString()).toAscii().data());
        
        emit downloadFailed();
    }
    else
    {
        QString fileName = QFileInfo(QUrl(fullTotozName).path()).fileName();
        emit sendUpdate();
    }

    delete file;
    file = 0;
}

void Totoz::readResponseHeader(const QHttpResponseHeader &responseHeader)
{
    
    if ((responseHeader.statusCode() != 200) and (responseHeader.statusCode() != 302))
    {
        
        emit downloadFailed();
        return;
    }    
}

void Totoz::mywget()
{
    QUrl url(fullTotozName);
    QFileInfo fileInfo(url.path());   
    
    
    file = new QFile(localTotozName);
    if (!file->open(QIODevice::WriteOnly)) {
        
        delete file;
        file = 0;
        return;
    }
    
    
    qDebug((fullTotozName.toLatin1() ).data());
    
    http->setHost(url.host(), url.port() != -1 ? url.port() : 80);
    if (!url.userName().isEmpty())
        http->setUser(url.userName(), url.password());

    httpRequestAborted = false;
    httpGetId = http->get(url.path(), file);

    //emit updateTribuneStarted();    
}
